# Project Terracore: Mk1 "Backyard Builder" - Rapid Synthesis Prototype

## The Breakthrough: Meal Synthesis in Minutes, Not Months
The Mk1 demonstrates the core Terracore breakthrough: triggering pre-established hibernating mycelium to produce edible biomass within 10-30 minutes. This is not traditional mushroom growing - this is instant food synthesis.

## Total Cost: $250-350 USD
All components can be sourced from hardware stores, online marketplaces, or repurposed materials.

## Core Components & Function

### 1. Pre-Established Bio-Fabric ($40-60)
- Liquid Culture Jar: Pre-grown oyster mushroom mycelium
- Bulk Substrate: Pasteurized cardboard/paper pulp, fully colonized
- Sealed Container: Airtight vessel to maintain hibernation
- Purpose: Ready-to-activate living material that can be stored for months

### 2. Rapid-Activation Deposition System ($50-80)
- 12V Diaphragm Pump: High-flow liquid pump (espresso machine/car wash type)
- Solenoid Valve: Instant on/off control of nutrient flow
- Spray Nozzle: Even distribution across bio-fabric surface
- Pressure-Rated Bottle: Holds nutrient trigger slurry
- Purpose: Instant, even application of growth-triggering nutrients

### 3. Instant Environment Chamber ($80-120)
- Insulated Chamber: Styrofoam cooler or insulated box
- Heating System: 100-150W cartridge heater with pre-heated thermal mass
- Humidity System: Ultrasonic fogger maintaining 90%+ RH
- Sealing: Airtight door to maintain environment
- Purpose: Pre-heated, humidified environment ready for instant synthesis

### 4. Power & Control ($30-40)
- 12V 5A Power Supply: Runs pump, solenoid, and fogger
- Simple Timer/Switch: Controls synthesis cycle
- Basic Wiring: Connects all components
- Purpose: Automated control of the rapid synthesis process

## The 10-Minute Synthesis Cycle

1. Preparation (0-1 min): Place hibernating bio-fabric into pre-heated chamber
2. Trigger (1 min): Pump injects warm nutrient slurry across surface
3. Synthesis (2-10 min): Chamber sealed, mycelium rapidly fruits
4. Harvest (10 min): Open chamber, collect edible biomass

## What Makes This Different

- Speed: 10 minutes vs 3-4 weeks for traditional methods
- On-Demand: Synthesize food when needed, not when nature decides
- Storage: Bio-fabric can hibernate for months without maintenance
- Control: Perfect environmental conditions every time

## Output Capacity
- Produces 150-300g edible biomass per cycle
- Enough for 1-2 meals per synthesis session
- Multiple cycles possible per day with prepared bio-fabric

## Success Metrics
- Synthesis completes within 10-30 minutes
- Produces recognizable, edible mushroom fruiting bodies
- Bio-fabric remains viable for multiple synthesis cycles
- Entire system consumes less than $0.50 per synthesis in electricity and nutrients

## Why This Matters
This proves that rapid food synthesis isn't science fiction - it's achievable with simple, affordable technology. The Mk1 makes the core Terracore technology accessible to everyone, everywhere.
